package sample.com.bugnavigationpendingintent

import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.navigation.NavDeepLinkBuilder
import kotlinx.android.synthetic.main.fragment_main.*

class MainFragment: Fragment() {

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_main, container, false)
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)

        pendingIntentSuccess.setOnClickListener {
            NavDeepLinkBuilder(requireContext())
                    .setGraph(R.navigation.nav_graph)
                    .setDestination(R.id.other_fragment)
                    .createPendingIntent()
                    .send()
        }

        pendingIntentBug.setOnClickListener {
            val args = Bundle()
            args.putString("Hello", "World")

            NavDeepLinkBuilder(requireContext())
                    .setGraph(R.navigation.nav_graph)
                    .setDestination(R.id.other_fragment)
                    .setArguments(args)
                    .createPendingIntent()
                    .send()
        }
    }

}