package com.example.user.myapplication

import android.arch.lifecycle.Observer
import android.os.AsyncTask
import android.os.Bundle
import android.support.v7.app.AppCompatActivity
import android.util.Log
import androidx.work.OneTimeWorkRequest
import androidx.work.WorkManager
import androidx.work.WorkStatus
import kotlinx.android.synthetic.main.activity_main.*
import java.util.concurrent.TimeUnit

class MainActivity : AppCompatActivity() {
    val workManager = WorkManager.getInstance()!!


    companion object {
        const val normalJobTag = "normalJobTag"
        const val schedultedTag = "schedultedTag"
    }

    //    https://developer.android.com/topic/libraries/architecture/workmanager#kotlin
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        WorkManager.initialize(this, Configuration.Builder().build());
        setContentView(R.layout.activity_main)
        runButton.setOnClickListener {
            workManager.enqueue(OneTimeWorkRequest.Builder(SampleJob::class.java).addTag(normalJobTag).build())
        }
        cancelButton.setOnClickListener {
            workManager.cancelAllWorkByTag(normalJobTag)
        }
        scheduleButton.setOnClickListener {
            //            val photoCheckBuilder = PeriodicWorkRequest.Builder(SampleJob::class.java, 30, TimeUnit.SECONDS).addTag(schedultedTag)
//            val photoCheckWork = photoCheckBuilder.build()
//            workManager.enqueue(photoCheckWork)
//            val myConstraints = Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).setRequiresCharging(true).build()
//            val data = Data.Builder().putInt("KEY_X_ARG", 42)
//                    .putInt("KEY_Y_ARG", 421).putInt("KEY_Z_ARG", 8675309).build()
            workManager.enqueue(OneTimeWorkRequest.Builder(SampleJob::class.java).addTag(schedultedTag).setInitialDelay(30, TimeUnit.SECONDS)
//                    .setInputData(data)
//                    .setConstraints(myConstraints)
                    .build())
            Log.d("AppLog", "scheduled")
        }

        workManager.getStatusesByTag(schedultedTag).observe(this, object : Observer<MutableList<WorkStatus>> {
            override fun onChanged(scheduledTagWorkStatuses: MutableList<WorkStatus>?) {
                Log.d("AppLog", "tag:$schedultedTag - statuses:")
                if (scheduledTagWorkStatuses != null)
                    for (status in scheduledTagWorkStatuses) {
                        Log.d("AppLog", status.state.toString())
                    }
            }
        })

        workManager.getStatusesByTag(normalJobTag).observe(this, object : Observer<MutableList<WorkStatus>> {
            override fun onChanged(scheduledTagWorkStatuses: MutableList<WorkStatus>?) {
                Log.d("AppLog", "tag:$normalJobTag - statuses:")
                if (scheduledTagWorkStatuses != null)
                    for (status in scheduledTagWorkStatuses) {
                        Log.d("AppLog", status.state.toString())
                    }
            }
        })

        checkAsyncButton.setOnClickListener {
            AsyncTask.execute {
                Log.d("AppLog", "checking...")
                val scheduledTagWorkStatuses = workManager.synchronous().getStatusesByTagSync(schedultedTag)
                val normalJobTagStatuses = workManager.synchronous().getStatusesByTagSync(normalJobTag)
                Log.d("AppLog", "tag:$schedultedTag - statuses:")
                for (status in scheduledTagWorkStatuses)
                    Log.d("AppLog", status.state.toString())
                Log.d("AppLog", "tag:$normalJobTag - statuses:")
                for (status in normalJobTagStatuses)
                    Log.d("AppLog", status.state.toString())

            }
        }

    }
}
