package com.example.user.myapplication

import android.os.Handler
import android.os.Looper
import android.util.Log
import android.widget.Toast
import androidx.work.Worker

class SampleJob : Worker() {

    override fun doWork(): Result {
        Log.d("AppLog", "doing work...")
        Handler(Looper.getMainLooper()).post {
            Toast.makeText(applicationContext, "working...", Toast.LENGTH_SHORT).show()
        }
        if (inputData.size() > 0) {
            Log.d("AppLog", "got inputData:")
            for (entry in inputData.keyValueMap.entries) {
                Log.d("AppLog", "${entry.key} - ${entry.value}")
            }
        }
        try {
            Thread.sleep(2000)
        } catch (e: InterruptedException) {
            Log.d("AppLog", "interrupted")
        }
        Log.d("AppLog", "done with work")
        Handler(Looper.getMainLooper()).post {
            Toast.makeText(applicationContext, "done working", Toast.LENGTH_SHORT).show()
        }
        return Result.SUCCESS
    }

}
