package com.hegazy.roomtypeconverterbug.db

import android.arch.persistence.room.TypeConverter

import com.google.gson.Gson


class CategoryListConverter {

    private var gson: Gson = Gson()

    @TypeConverter
    fun fromJson(categoriesJson: String?): List<Category>? {
        return gson.fromJson<List<Category>>(categoriesJson)
    }

    @TypeConverter
    fun toJson(categories: List<Category>?): String? {
        return if (categories == null) null else gson.toJson(categories)
    }
}
