package com.example.navigationcrash

import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import androidx.navigation.fragment.findNavController

class FragmentA : Fragment() {

    private val sharedViewModel: SharedViewModel by lazy {
        ViewModelProviders.of(requireActivity()).get(SharedViewModel::class.java)
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_a, container, false).also {
            it.findViewById<Button>(R.id.button).setOnClickListener {
                findNavController().navigate(R.id.action_show_c)
            }
        }
    }

    override fun onResume() {
        super.onResume()

        // conditional navigation causing crash when backstack is being popped
        if (sharedViewModel.someConditionCausingNavigationToB) {
            findNavController().navigate(R.id.action_show_b)
            sharedViewModel.someConditionCausingNavigationToB = false
        }
    }
}