package c.b.a.myapplication

import android.os.Bundle
import android.support.v7.app.AppCompatActivity
import android.util.Log
import android.widget.Button
import androidx.work.*
import com.squareup.moshi.JsonAdapter
import com.squareup.moshi.Moshi
import java.nio.charset.Charset
import java.util.*
import kotlin.concurrent.thread

val moshi = Moshi.Builder().build()
inline fun <reified T> moshiAdapter(): JsonAdapter<T> = moshi.adapter()
inline fun <reified T> Moshi.adapter(): JsonAdapter<T> = adapter(T::class.java)

class MainActivity : AppCompatActivity() {

  override fun onCreate(savedInstanceState: Bundle?) {
    super.onCreate(savedInstanceState)
    setContentView(R.layout.activity_main)

    val wmConfig = Configuration
      .Builder()
      .setMinimumLoggingLevel(Log.VERBOSE)
      .setMaxSchedulerLimit(95)
      .build()
    WorkManager.initialize(applicationContext, wmConfig)
    val wm = WorkManager.getInstance()

    findViewById<Button>(R.id.scheduler_limits_testcase1).setOnClickListener {
      thread {

        data class TreeModel(
          val tree: List<String>,
          val childToParent: Map<String, String>,
          val leafs: List<String>
        )

        val trees = assets
          .open("jobs.json")
          .readBytes()
          .toString(Charset.defaultCharset())
          .let(moshiAdapter<Array<TreeModel>>()::fromJson)

        trees.forEach { (tree, childToParent, leafs) ->
          val requests = tree.associate {
            val fail = it == childToParent.keys.last()
            it to newWorkRequest(it, network = true, fail = fail)
          }
          childToParent.forEach { child, parent ->
            wm
              .beginWith(requests.getValue(parent))
              .then(requests.getValue(child))
              .enqueue()
          }
          val finishJob = newWorkRequest("finish", network = false)
          val leafs = leafs.map(requests::getValue)
          wm
            .beginWith(leafs)
            .then(finishJob)
            .enqueue()
        }
      }
    }
  }

  companion object {
    private fun newWorkRequest(message: String,
                               network: Boolean,
                               fail: Boolean = false): OneTimeWorkRequest =
      OneTimeWorkRequest.Builder(TestWorker::class.java)
        .setInputData(Data.Builder().putAll(mapOf(
          TestWorker.KEY_MESSAGE to message,
          TestWorker.FAIL to fail
        )).build())
        .apply {
          if (network) setConstraints(Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build())
        }
        .addTag("TEST_TAG")
        .build()
  }
}

class TestWorker : Worker() {
  companion object {
    private const val TAG = "TestWorker"
    const val KEY_MESSAGE = "KEY_MESSAGE"
    const val FAIL = "KEY_MESSAGE2"
  }

  override fun doWork(): Result {
    val message = inputData.getString(KEY_MESSAGE)
    val random = Random()
    val time = 150L + random.nextInt(50)
    Log.d(TAG, "Before. $message")
    Thread.sleep(time)
    Log.d(TAG, "After. $message")
    outputData = Data.Builder().apply { putLongArray("z", longArrayOf(1, 2, 3, 4)) }.build()
    val fail = inputData.getBoolean(FAIL, false)
    return when {
      fail -> Result.FAILURE
      else -> Result.SUCCESS
    }
  }
}