package c.b.a.myapplication

import android.os.Bundle
import android.support.v7.app.AppCompatActivity
import android.util.Log
import androidx.work.*
import timber.log.Timber
import java.util.*
import kotlin.concurrent.thread

class MainActivity2 : AppCompatActivity() {

  override fun onCreate(savedInstanceState: Bundle?) {
    super.onCreate(savedInstanceState)

    val wmConfig = Configuration
      .Builder()
      .setMaxSchedulerLimit(95)
      .setMinimumLoggingLevel(Log.VERBOSE)
      .build()
    WorkManager.initialize(applicationContext, wmConfig)

    thread {
      askjd()
    }
  }

  private fun askjd() {
    val wm = WorkManager.getInstance()
    repeat(150) {
      val a1 = job("$it-a1")
      val b1 = job("$it-b1")
      val b2 = job("$it-b2")
      val c1 = job("$it-c1")
      wm.beginWith(a1).then(b1).enqueue()
      wm.beginWith(a1).then(b2).enqueue()
      wm.beginWith(b1, b2).then(c1).enqueue()
    }
  }

  private fun job(print: String) = OneTimeWorkRequest
    .Builder(TestWorker::class.java)
    .setInputData(Data.Builder().putAll(mapOf(TestWorker.print to print)).build())
    .build()

  class TestWorker : Worker() {
    companion object {

      const val print = "pritn"
    }

    override fun doWork(): Result {
      Thread.sleep(150L + Random().nextInt(50))
      Timber.tag("TESTING").d("----------------${inputData.getString(print)}-----------------")
      return Result.SUCCESS
    }
  }
}