package com.demo.bugcrashnamedfragmenttransaction112927148

import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentManager
import androidx.navigation.fragment.NavHostFragment
import androidx.navigation.ui.NavigationUI
import kotlinx.android.synthetic.main.activity_main.*

class MainActivity : AppCompatActivity() {

    private val navController by lazy { NavHostFragment.findNavController(navHostFragment) }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        NavigationUI.setupActionBarWithNavController(this, navController)
    }

    override fun onSupportNavigateUp() = navController.navigateUp()
}

val FragmentManager.backStack: List<FragmentManager.BackStackEntry>
    get() = (0 until backStackEntryCount).toList().map { getBackStackEntryAt(it) }


fun Fragment.willCrashOnBack(): Boolean {
    return requireFragmentManager().backStack.firstOrNull { it.name == "TRANSACTION_NAME" } !== null
}

var View.isVisible
    get() = visibility == View.VISIBLE
    set(value) { visibility = if (value) View.VISIBLE else View.GONE }

