package com.demo.bugcrashnamedfragmenttransaction112927148

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.navigation.Navigation
import kotlinx.android.synthetic.main.fragment_main.*

class MainFragment : Fragment() {
    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_main, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        add_named_transaction.setOnClickListener {
            requireFragmentManager().beginTransaction()
                    .addToBackStack("TRANSACTION_NAME")
                    .commit()
        }
        go_to_some_destination.setOnClickListener {
            Navigation.findNavController(it).navigate(R.id.action_goToDestination)
        }
        requireFragmentManager().addOnBackStackChangedListener {
            refresh()
        }
    }

    override fun onResume() {
        super.onResume()
        refresh()
    }

    fun refresh() {
        willCrashOnBack().let { willCrash ->
            add_named_transaction?.isEnabled = !willCrash
            named_transaction_present?.isVisible = willCrash
        }
    }
}