package com.test.navtest


import android.os.Bundle
import android.support.v7.app.AppCompatActivity
import android.util.Log
import android.view.View
import android.widget.Toast
import androidx.navigation.NavController
import androidx.navigation.Navigation

class MainActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        getNavController().addOnNavigatedListener { controller, destination ->
            Log.d("NAV", destination.label?.toString() ?: "")
        }
    }

    fun popToRoot(v: View) {
        val nc = getNavController()
        nc.popBackStack(R.id.fragmentA, false)
    }

    fun pop(v: View) {
        val nc = getNavController()
        nc.popBackStack()
    }

    fun up(v: View) {
        val nc = getNavController()
        nc.navigateUp()
    }

    fun checkPage(v: View) {
        Toast.makeText(this, getNavController().currentDestination?.label ?: "Unknown", Toast.LENGTH_SHORT).show()
    }

    private fun getNavController(): NavController {
        return Navigation.findNavController(this, R.id.nav_host)
    }

}
