package a.com.myapplication;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.room.Database;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SupportSQLiteDatabase;

@Database(entities = {DataItem.class}, version = 1)
public abstract class AppDatabase extends RoomDatabase {

    private static AppDatabase INSTANCE;
    private final static Object lockObject = new Object();

    public static AppDatabase getDatabase(final Context context) {
        if (INSTANCE == null) {
            synchronized (lockObject) {
                Builder<AppDatabase> builder = Room.databaseBuilder(context.getApplicationContext(), AppDatabase.class, "mydb.sqlite")
                        .addCallback(new Callback() {

                            @Override
                            public void onCreate(@NonNull SupportSQLiteDatabase db) {
                                super.onCreate(db);
                            }

                            @Override
                            public void onOpen(@NonNull SupportSQLiteDatabase db) {
                                super.onOpen(db);
                            }
                        });

                builder.allowMainThreadQueries();

                // turn off Write-Ahead Logging
                builder.setJournalMode(JournalMode.TRUNCATE);

                INSTANCE = builder.build();
            }
        }
        return INSTANCE;
    }

    public abstract DataItemDao dataItemDao();
}
