package a.com.myapplication;

import java.util.List;

import androidx.paging.DataSource;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

@Dao
public interface DataItemDao {
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    List<Long> insertOrUpdate(List<DataItem> items);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    long insertOrUpdate(DataItem item);

    @Query("SELECT * FROM DataItem order by id")
    DataSource.Factory<Integer, DataItem> getAllData();
}
