package a.com.myapplication;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProviders;
import androidx.paging.LivePagedListBuilder;
import androidx.paging.PagedList;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Bundle;

import java.util.List;

public class MainActivity extends AppCompatActivity {

    private MainViewModel viewModel;
    private MyAdapter adapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        viewModel = ViewModelProviders.of(this).get(MainViewModel.class);

        RecyclerView recyclerView = findViewById(R.id.recyclerview);
        recyclerView.setHasFixedSize(true);
        LinearLayoutManager mLayoutManager = new LinearLayoutManager(this);
        recyclerView.setLayoutManager(mLayoutManager);

        StateListDrawable verticalThumbDrawable = (StateListDrawable) getDrawable(R.drawable.fastscroll_thumb_selector);
        Drawable verticalTrackDrawable = getDrawable(R.drawable.line);
        StateListDrawable horizontalThumbDrawable = (StateListDrawable) getDrawable(R.drawable.fastscroll_thumb_selector);
        Drawable horizontalTrackDrawable = getDrawable(R.drawable.line);

        Resources resources = getResources();
        new FastScroller(recyclerView, verticalThumbDrawable, verticalTrackDrawable,
                horizontalThumbDrawable, horizontalTrackDrawable,
                120,
                resources.getDimensionPixelSize(androidx.recyclerview.R.dimen.fastscroll_minimum_range),
                resources.getDimensionPixelOffset(androidx.recyclerview.R.dimen.fastscroll_margin));

        adapter = new MyAdapter(new DiffUtil.ItemCallback<DataItem>() {

            @Override
            public boolean areItemsTheSame(@NonNull DataItem oldItem, @NonNull DataItem newItem) {
                return oldItem.getId() == newItem.getId();
            }

            @Override
            public boolean areContentsTheSame(@NonNull DataItem oldItem, @NonNull DataItem newItem) {
                return (oldItem.getId() == newItem.getId() && oldItem.getTitle().equals(newItem.getTitle()));
            }
        });

        recyclerView.setAdapter(adapter);

        viewModel.getItems().observe(this, new Observer<PagedList<DataItem>>() {
            @Override
            public void onChanged(PagedList<DataItem> dataItems) {
                adapter.submitList(dataItems);
            }
        });
    }


}
