package a.com.myapplication;

import android.app.Application;

import java.util.LinkedList;
import java.util.List;

import androidx.annotation.NonNull;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;
import androidx.paging.LivePagedListBuilder;
import androidx.paging.PagedList;

public class MainViewModel extends AndroidViewModel {
    private LiveData<PagedList<DataItem>> items;
    private AppDatabase db;

    public MainViewModel(@NonNull Application application) {
        super(application);

        db = AppDatabase.getDatabase(getApplication());

        List<DataItem> data = new LinkedList<>();
        for(int i = 0; i < 5000; i++) {
            data.add(new DataItem(i, "Item " + i, "Item " + i, "Item " + i, "Item " + i, "Item " + i, "Item " + i, "Item " + i));
        }
        db.dataItemDao().insertOrUpdate(data);

        new Thread(new Runnable() {
            @Override
            public void run() {
                for(int i = 0; i < 5000; i++) {
                    db.dataItemDao().insertOrUpdate(new DataItem(i, "Item " + i, "Item " + i, "Item " + i, "Item " + i, "Item " + i, "Item " + i, "Item " + i));
                    try {
                        Thread.sleep(1000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    public LiveData<PagedList<DataItem>> getItems() {
        if(items == null) {
            LivePagedListBuilder<Integer, DataItem> livePagedListBuilder =
                    new LivePagedListBuilder<>(db.dataItemDao().getAllData(), getPagedListConfig());
            items = livePagedListBuilder.build();
        }
        return items;
    }

    private final static int PAGE_SIZE = 20;

    private final static int INIT_LOAD_SIZE = 60;
    private final static boolean ENABLE_PLACEHOLDERS = true;

    static PagedList.Config getPagedListConfig() {
        return new PagedList.Config.Builder()
                .setPageSize(PAGE_SIZE)
                .setEnablePlaceholders(ENABLE_PLACEHOLDERS)
                .setInitialLoadSizeHint(INIT_LOAD_SIZE)
                .build();
    }
}
