package a.com.myapplication;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.paging.PagedListAdapter;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;

public class MyAdapter extends PagedListAdapter<DataItem, MyAdapter.ItemViewHolder> {

    class ItemViewHolder extends RecyclerView.ViewHolder {
        TextView titleView;

        ItemViewHolder(View v) {
            super(v);

            titleView = v.findViewById(R.id.textView);
        }
    }

    public MyAdapter(DiffUtil.ItemCallback<DataItem> diffCallback) {
        super(diffCallback);
    }

    @NonNull
    @Override
    public ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from(parent.getContext());

        View v = inflater.inflate(R.layout.list_item, parent, false);
        return new ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull final ItemViewHolder viewHolder, int position) {
        DataItem item = getItem(position);
        if(item == null)
            return;

        viewHolder.titleView.setText(item.getTitle());
    }
}
