package com.example.anon.workmanagertest;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.Observer;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.FloatingActionButton;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.View;

import java.util.List;

import androidx.work.ExistingWorkPolicy;
import androidx.work.OneTimeWorkRequest;
import androidx.work.State;
import androidx.work.WorkManager;
import androidx.work.WorkStatus;

public class MainActivity extends AppCompatActivity
{

    final static String TAG = "WorkmanagerTest";
    final static String UNIQUE_WORK_TAG = "UNIQUE_WORK_TAG";

    private LiveData<List<WorkStatus>> mStatusUniqueWork;
    private Thread.UncaughtExceptionHandler androidDefaultUEH;

    private long workerSuccessCounter = 0;

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

        // Set uncaught exception handler
        androidDefaultUEH = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(handler);

        registerObserver();

        FloatingActionButton fab = (FloatingActionButton) findViewById(R.id.fab);
        fab.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View view)
            {

                Log.i(TAG, "onClick()");

                Log.i(TAG, "enqueuing a single unique worker with replace policy.");
                enqueUniqueWork();
            }
        });
    }

    private void registerObserver()
    {
        mStatusUniqueWork = WorkManager.getInstance().getStatusesForUniqueWork(UNIQUE_WORK_TAG);
        if (mStatusUniqueWork != null)
        {
            mStatusUniqueWork.observeForever(new Observer<List<WorkStatus>>()
            {
                @Override
                public void onChanged(@Nullable List<WorkStatus> workStatuses)
                {
                    if (workStatuses == null || workStatuses.isEmpty())
                    {
                        return;
                    }

                    // has only one worker with a unique tag.
                    WorkStatus workStatus = workStatuses.get(0);

                    Log.i(TAG, "Worker state is: " + workStatus.getState());

                    if (workStatus.getState() == State.SUCCEEDED)
                    {
                        workerSuccessCounter++;
                        Log.i(TAG, "Worker is finished, enqueueing new worker... (Counter for success=" + workerSuccessCounter + ")");
                        enqueUniqueWork();
                    }
                }
            });
        }
    }

    private static void enqueUniqueWork()
    {

        WorkManager workManager1 = WorkManager.getInstance();


        OneTimeWorkRequest work = new OneTimeWorkRequest.Builder(AnyUniqueWorkRequestWorker.class)
                .build();

        workManager1.beginUniqueWork(UNIQUE_WORK_TAG, ExistingWorkPolicy.REPLACE, work).enqueue();
    }

    private Thread.UncaughtExceptionHandler handler = new Thread.UncaughtExceptionHandler()
    {
        public void uncaughtException(Thread thread, Throwable ex)
        {
            Log.e(TAG, "Uncaught exception is: ", ex);
            androidDefaultUEH.uncaughtException(thread, ex);
        }
    };


}
