package gmk57.roomtest;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Transaction;

import java.util.List;

@Dao
abstract class DataDao {

    @Query("SELECT * FROM Data")
    abstract LiveData<List<Data>> getAll();

    @Insert
    abstract void insert(Data... data);

    @Insert(onConflict = OnConflictStrategy.ROLLBACK)
    abstract void insertRollback(Data... data);

    @Query("DELETE FROM Data")
    abstract void clear();

    @Transaction
    void clearAndInsert(Data... data) {
        clear();
        insert(data);
    }
}
