package gmk57.roomtest;

import androidx.room.Room;
import android.database.sqlite.SQLiteConstraintException;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.Toast;

import java.util.List;

public class MainActivity extends AppCompatActivity {

    private static final String TAG = "MainActivity";
    private DataDao dataDao;
    private ListView lvData;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_main);

        AppDatabase database = Room.databaseBuilder(getApplicationContext(), AppDatabase.class, "appdatabase").build();
        dataDao = database.dataDao();
        dataDao.getAll().observe(this, this::showData);

        new Thread(this::initDb).start();

        lvData = findViewById(R.id.lv_data);

        Button btnViolate = findViewById(R.id.btn_violate_abort);
        btnViolate.setOnClickListener(v -> new Thread(this::violateAbort).start());

        Button btnViolateRb = findViewById(R.id.btn_violate_rollback);
        btnViolateRb.setOnClickListener(v -> new Thread(this::violateRollback).start());
    }

    private void showData(List<Data> list) {
        Log.v(TAG, "list: " + list);
        lvData.setAdapter(new ArrayAdapter<>(this, android.R.layout.simple_list_item_1, list));
    }

    private void initDb() {
        try {
            dataDao.clearAndInsert(new Data("One", "1"), new Data("Two", "2"), new Data("Three", "3"));
        } catch (SQLiteConstraintException e) {
            Log.e(TAG, "initDb failed: " + e);
            lvData.post(() -> Toast.makeText(this, e.toString(), Toast.LENGTH_LONG).show());
        }
    }

    private void violateAbort() {
        try {
            dataDao.insert(new Data("Four", "4"), new Data("Five", "5"), new Data("Five", "6"));
        } catch (SQLiteConstraintException e) {
            Log.e(TAG, "violateAbort failed: " + e);
            lvData.post(() -> Toast.makeText(this, e.toString(), Toast.LENGTH_LONG).show());
        }
    }

    private void violateRollback() {
        try {
            dataDao.insertRollback(new Data("Four", "4"), new Data("Five", "5"), new Data("Five", "6"));
        } catch (SQLiteConstraintException e) {
            Log.e(TAG, "violateRollback failed: " + e);
            lvData.post(() -> Toast.makeText(this, e.toString(), Toast.LENGTH_LONG).show());
        }
    }
}
