/*
 * Decompiled with CFR 0.152.
 */
package com.onbarcode.barcode.android;

import android.graphics.Color;
import android.graphics.Paint;

public class AndroidColor {
    public static AndroidColor black = new AndroidColor(-16777216);
    public static AndroidColor gray = new AndroidColor(-7829368);
    public static AndroidColor ltgray = new AndroidColor(-3355444);
    public static AndroidColor darkGray = new AndroidColor(-12303292);
    public static AndroidColor white = new AndroidColor(-1);
    public static AndroidColor blue = new AndroidColor(-16776961);
    public static AndroidColor yellow = new AndroidColor(-256);
    public static AndroidColor green = new AndroidColor(-16711936);
    public static AndroidColor pink = new AndroidColor(255, 175, 175);
    public static AndroidColor red = new AndroidColor(-65536);
    public static AndroidColor orange = new AndroidColor(255, 200, 0);
    public static final AndroidColor VERY_DARK_RED = new AndroidColor(128, 0, 0);
    public static final AndroidColor DARK_RED = new AndroidColor(192, 0, 0);
    public static final AndroidColor LIGHT_RED = new AndroidColor(255, 64, 64);
    public static final AndroidColor VERY_LIGHT_RED = new AndroidColor(255, 128, 128);
    public static final AndroidColor VERY_DARK_YELLOW = new AndroidColor(128, 128, 0);
    public static final AndroidColor DARK_YELLOW = new AndroidColor(192, 192, 0);
    public static final AndroidColor LIGHT_YELLOW = new AndroidColor(255, 255, 64);
    public static final AndroidColor VERY_LIGHT_YELLOW = new AndroidColor(255, 255, 128);
    public static final AndroidColor VERY_DARK_GREEN = new AndroidColor(0, 128, 0);
    public static final AndroidColor DARK_GREEN = new AndroidColor(0, 192, 0);
    public static final AndroidColor LIGHT_GREEN = new AndroidColor(64, 255, 64);
    public static final AndroidColor VERY_LIGHT_GREEN = new AndroidColor(128, 255, 128);
    public static final AndroidColor VERY_DARK_CYAN = new AndroidColor(0, 128, 128);
    public static final AndroidColor DARK_CYAN = new AndroidColor(0, 192, 192);
    public static final AndroidColor LIGHT_CYAN = new AndroidColor(64, 255, 255);
    public static final AndroidColor VERY_LIGHT_CYAN = new AndroidColor(128, 255, 255);
    public static final AndroidColor VERY_DARK_BLUE = new AndroidColor(0, 0, 128);
    public static final AndroidColor DARK_BLUE = new AndroidColor(0, 0, 192);
    public static final AndroidColor LIGHT_BLUE = new AndroidColor(64, 64, 255);
    public static final AndroidColor VERY_LIGHT_BLUE = new AndroidColor(128, 128, 255);
    public static final AndroidColor VERY_DARK_MAGENTA = new AndroidColor(128, 0, 128);
    public static final AndroidColor DARK_MAGENTA = new AndroidColor(192, 0, 192);
    public static final AndroidColor LIGHT_MAGENTA = new AndroidColor(255, 64, 255);
    public static final AndroidColor VERY_LIGHT_MAGENTA = new AndroidColor(255, 128, 255);
    private int a;

    public AndroidColor() {
        this.a = 0;
    }

    public AndroidColor(int n2) {
        this.a = n2;
    }

    public AndroidColor(int n2, int n3, int n4) {
        this.a = Color.rgb((int)n2, (int)n3, (int)n4);
    }

    public AndroidColor(int n2, int n3, int n4, int n5) {
        this.a = Color.argb((int)n2, (int)n3, (int)n4, (int)n5);
    }

    public static AndroidColor decode(String string2) throws NumberFormatException {
        Integer n2 = Integer.decode(string2);
        int n3 = n2;
        return new AndroidColor(n3 >> 16 & 0xFF, n3 >> 8 & 0xFF, n3 & 0xFF);
    }

    public int getAlpha() {
        return Color.alpha((int)this.a);
    }

    public int getRed() {
        return Color.red((int)this.a);
    }

    public int getGreen() {
        return Color.green((int)this.a);
    }

    public int getBlue() {
        return Color.blue((int)this.a);
    }

    public String toString() {
        return "AndroidColor color: r: " + Color.red((int)this.a) + ", g: " + Color.green((int)this.a) + ", b:" + Color.blue((int)this.a) + ", alpha:" + this.getAlpha();
    }

    public AndroidColor brighter() {
        double d2 = 0.7;
        int n2 = Color.red((int)this.a);
        int n3 = Color.green((int)this.a);
        int n4 = Color.blue((int)this.a);
        int n5 = (int)(1.0 / (1.0 - d2));
        if (n2 == 0 && n3 == 0 && n4 == 0) {
            return new AndroidColor(n5, n5, n5);
        }
        if (n2 > 0 && n2 < n5) {
            n2 = n5;
        }
        if (n3 > 0 && n3 < n5) {
            n3 = n5;
        }
        if (n4 > 0 && n4 < n5) {
            n4 = n5;
        }
        return new AndroidColor(Math.min((int)((double)n2 / d2), 255), Math.min((int)((double)n3 / d2), 255), Math.min((int)((double)n4 / d2), 255));
    }

    public AndroidColor darker() {
        double d2 = 0.7;
        int n2 = Color.red((int)this.a);
        int n3 = Color.green((int)this.a);
        int n4 = Color.blue((int)this.a);
        return new AndroidColor(Math.max((int)((double)n2 * d2), 0), Math.max((int)((double)n3 * d2), 0), Math.max((int)((double)n4 * d2), 0));
    }

    public int getColor() {
        return this.a;
    }

    public void setColor(int n2) {
        this.a = n2;
    }

    public void updatePaint(Paint paint) {
        paint.setShader(null);
        paint.setColor(this.a);
    }

    public static void paint(AndroidColor androidColor, Paint paint) {
        if (androidColor == null) {
            return;
        }
        androidColor.updatePaint(paint);
    }

    public static AndroidColor[] createDefaultColorArray() {
        return new AndroidColor[]{new AndroidColor(255, 85, 85), new AndroidColor(85, 85, 255), new AndroidColor(85, 255, 85), new AndroidColor(255, 255, 85), new AndroidColor(255, 85, 255), new AndroidColor(85, 255, 255), pink, gray, DARK_RED, DARK_BLUE, DARK_GREEN, DARK_YELLOW, DARK_MAGENTA, DARK_CYAN, darkGray, LIGHT_RED, LIGHT_BLUE, LIGHT_GREEN, LIGHT_YELLOW, LIGHT_MAGENTA, LIGHT_CYAN, ltgray, VERY_DARK_RED, VERY_DARK_BLUE, VERY_DARK_GREEN, VERY_DARK_YELLOW, VERY_DARK_MAGENTA, VERY_DARK_CYAN, VERY_LIGHT_RED, VERY_LIGHT_BLUE, VERY_LIGHT_GREEN, VERY_LIGHT_YELLOW, VERY_LIGHT_MAGENTA, VERY_LIGHT_CYAN};
    }
}

