# Add project specific ProGuard rules here.
# By default, the flags in this file are appended to flags specified
# in /home/ankit/Android/Sdk/tools/proguard/proguard-android.txt
# You can edit the include path and order by changing the proguardFiles
# directive in build.gradle.
#
# For more details, see
#   http://developer.android.com/guide/developing/tools/proguard.html

# Add any project specific keep options here:

# If your project uses WebView with JS, uncomment the following
# and specify the fully qualified class name to the JavaScript interface
# class:
#-keepclassmembers class fqcn.of.javascript.interface.for.webview {
#   public *;
#}

# If you keep the line number information, uncomment this to
# hide the original source file name.
#-renamesourcefileattribute SourceFile

# SearchView
-keep class android.support.v7.widget.SearchView { *; }

# ez-vcard
-dontwarn com.fasterxml.jackson.**		# Jackson JSON Processor (for jCards) not used
-dontwarn freemarker.**				# freemarker templating library (for creating hCards) not used
-dontwarn org.jsoup.**				# jsoup library (for hCard parsing) not used
-dontwarn ezvcard.io.json.**
-keep class ezvcard.property.** { *; }		# keep all VCard properties (created at runtime)

# ical4j: ignore unused dynamic libraries
-dontwarn aQute.**
-dontwarn groovy.**				# Groovy-based ContentBuilder not used
-dontwarn org.codehaus.groovy.**
-dontwarn org.apache.commons.logging.**		# Commons logging is not available
-dontwarn net.fortuna.ical4j.model.**		# ignore warnings from Groovy dependency
-dontwarn org.slf4j.**
-dontwarn sun.misc.Perf
-dontwarn groovyjarjarantlr.**
-dontwarn groovyjarjarasm.**
-dontwarn net.fortuna.ical4j.util.**
-keep class net.fortuna.ical4j.validate.**
-keep class net.fortuna.ical4j.model.**

# Unknown
-dontwarn rx.internal.util.unsafe.**

# EventBus
-keepattributes *Annotation*
-keepclassmembers class * {
    @org.greenrobot.eventbus.Subscribe <methods>;
}
-keep enum org.greenrobot.eventbus.ThreadMode { *; }

# Guava
-dontwarn org.checkerframework.**
-dontwarn com.google.**
-dontwarn afu.org.**

# Matisse
-dontwarn com.squareup.picasso.**

# Crashlytics
-keepattributes SourceFile,LineNumberTable

# Billing
-keep class com.android.vending.billing.**

# Dagger
-dontwarn dagger.android.**

# Parceler library
-keep interface org.parceler.Parcel
-keep @org.parceler.Parcel class * { *; }
-keep class **$$Parcelable { *; }

# Fast quickAdapter
-dontwarn com.mikepenz.fastadapter_extensions.items.**

# BRVAH
-keep class com.chad.library.adapter.** {
*;
}
-keep public class * extends com.chad.library.adapter.base.BaseQuickAdapter
-keep public class * extends com.chad.library.adapter.base.BaseViewHolder
-keepclassmembers  class **$** extends com.chad.library.adapter.base.BaseViewHolder {
     <init>(...);
}

# Sheet FAB
-keep class io.codetail.animation.arcanimator.** { *; }
