package ab.issue.application;

import android.content.Context;
import android.support.multidex.MultiDex;

import net.danlew.android.joda.JodaTimeAndroid;

import ab.issue.BuildConfig;
import ab.issue.di.DaggerAppComponent;
import ab.issue.utils.Constants;
import app.issue.commons.BaseApplication;
import app.issue.commons.CommonsModule;
import dagger.android.AndroidInjector;
import dagger.android.support.DaggerApplication;

/**
 * @author abatra.
 */
public class BarcodeReaderApp extends BaseApplication {


    public static final String URL_SHORT = "https://goo.gl/C6Q1TZ";
    public static final String EMAIL = "android.app.doodle@gmail.com";

    @Override
    public void onCreate() {
        super.onCreate();
        JodaTimeAndroid.init(this);
    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        MultiDex.install(this);
    }

    @Override
    protected AndroidInjector<? extends DaggerApplication> applicationInjector() {
        return DaggerAppComponent.builder()
                .application(this)
                .commonModule(new CommonsModule(Constants.AUTHORITY))
                .build();
    }

    @Override
    protected boolean isDebug() {
        return BuildConfig.DEBUG;
    }
}
