package ab.issue.db;

import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.TypeConverters;
import android.content.Context;

import ab.issue.model.Barcode;
import ab.issue.model.values.CalendarEventBarcodeFormat;
import ab.issue.model.values.ContactInfoBarcodeFormat;
import ab.issue.model.values.EmailBarcodeFormat;
import ab.issue.model.values.GeoBarcodeFormat;
import ab.issue.model.values.PhoneBarcodeFormat;
import ab.issue.model.values.SmsBarcodeFormat;
import ab.issue.model.values.UrlBarcodeFormat;
import ab.issue.model.values.WifiBarcodeFormat;
import ab.issue.utils.JodaUtils;

@TypeConverters(JodaUtils.class)
@Database(entities = {
        Barcode.class,
        CalendarEventBarcodeFormat.class,
        ContactInfoBarcodeFormat.class,
        EmailBarcodeFormat.class,
        GeoBarcodeFormat.class,
        PhoneBarcodeFormat.class,
        SmsBarcodeFormat.class,
        UrlBarcodeFormat.class,
        WifiBarcodeFormat.class

}, version = DbConstants.CURRENT_VERSION)
public abstract class BarcodeDatabase extends RoomDatabase {

    private static BarcodeDatabase INSTANCE;

    public abstract WifiDao wifiValueDao();

    public abstract CalendarEventDao calendarEventDao();

    public abstract ContactDao contactDao();

    public abstract EmailDao emailDao();

    public abstract GeoDao geoDao();

    public abstract SmsDao smsDao();

    public abstract UrlDao urlDao();

    public abstract PhoneDao phoneDao();

    abstract BarcodeDao barcodeDao();

    abstract HistoryDao historyDao();

    abstract SearchDao searchDao();

    static synchronized BarcodeDatabase getInstance(Context context) {
        if (INSTANCE == null) {
            synchronized (BarcodeDatabase.class) {
                if (INSTANCE == null) {
                    INSTANCE = Room.databaseBuilder(context, BarcodeDatabase.class, DbConstants.DATABASE_NAME).build();
                }
            }
        }
        return INSTANCE;
    }
}
