package ab.issue.db;

import java.util.List;

import ab.issue.db.model.BarcodeFormatValueWrapper;
import ab.issue.model.Barcode;
import ab.issue.model.values.BarcodeFormatValue;
import app.issue.commons.sqlite.room.IDao;

abstract class BarcodeFormatValueDao<FORMAT_VALUE extends BarcodeFormatValue, FORMAT_VALUE_WRAPPER extends BarcodeFormatValueWrapper>
        implements IDao<FORMAT_VALUE> {

    abstract List<FORMAT_VALUE_WRAPPER> findText(String text);

    public List<Barcode> findTextInBarcodeFormatValues(String text) {
        return BarcodeFormatValueWrapper.toBarcodes(findText(text));
    }
}
