package ab.issue.db;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Query;

import java.util.List;

import ab.issue.db.model.CalendarEventBarcode;
import ab.issue.model.values.CalendarEventBarcodeFormat;

import static ab.issue.db.DbConstants.*;

@Dao
public abstract class CalendarEventDao extends BarcodeFormatValueDao<CalendarEventBarcodeFormat, CalendarEventBarcode> {

    @Override
    @Query("SELECT " + BARCODE_TABLE_NAME + ".*, " + CALENDAR_EVENT_TABLE_NAME + ".* " +
            "FROM " + CALENDAR_EVENT_TABLE_NAME + " " +
            "INNER JOIN " + BARCODE_TABLE_NAME + " " +
            "ON " + COLUMN_NAME_EVENT_BARCODE_ID + " = " + COLUMN_NAME_BARCODE_ID + " " +
            "WHERE " + COLUMN_NAME_EVENT_DESCRIPTION + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_EVENT_LOCATION + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_EVENT_ORGANIZER + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_EVENT_STATUS + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_EVENT_SUMMARY + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_NOTES + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_DISPLAY_VALUE + " LIKE '%' || :text || '%'")
    abstract List<CalendarEventBarcode> findText(String text);
}
