package ab.issue.db;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Query;

import java.util.List;

import ab.issue.db.model.ContactInfoBarcode;
import ab.issue.model.values.ContactInfoBarcodeFormat;

import static ab.issue.db.DbConstants.*;

@Dao
public abstract class ContactDao extends BarcodeFormatValueDao<ContactInfoBarcodeFormat, ContactInfoBarcode> {

    @Override
    @Query("SELECT " + CONTACT_TABLE_NAME + ".*, " + BARCODE_TABLE_NAME + ".* " +
            "FROM " + CONTACT_TABLE_NAME + " " +
            "INNER JOIN " + BARCODE_TABLE_NAME + " " +
            "ON " + COLUMN_NAME_CONTACT_BARCODE_ID + " = " + COLUMN_NAME_BARCODE_ID + " " +
            "WHERE " + COLUMN_NAME_CONTACT_ADDRESS + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_CONTACT_EMAIL + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_CONTACT_URL + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_CONTACT_NAME + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_CONTACT_ORGANIZATION + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_CONTACT_PHONE + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_CONTACT_TITLE + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_NOTES + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_DISPLAY_VALUE + " LIKE '%' || :text || '%'")
    abstract List<ContactInfoBarcode> findText(String text);
}
