package ab.issue.db;

import android.content.Context;

import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;

@Module
public class DatabaseModule {

    @Provides
    @Singleton
    BarcodeDatabase barcodeDatabase(Context context) {
        return BarcodeDatabase.getInstance(context);
    }

    @Provides
    @Singleton
    HistoryDao historyDao(BarcodeDatabase barcodeDatabase) {
        return barcodeDatabase.historyDao();
    }

    @Provides
    @Singleton
    SearchDao searchDao(BarcodeDatabase barcodeDatabase) {
        return barcodeDatabase.searchDao();
    }
}
