package ab.issue.db;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Query;

import java.util.List;

import ab.issue.db.model.EmailBarcode;
import ab.issue.model.values.EmailBarcodeFormat;

import static ab.issue.db.DbConstants.BARCODE_TABLE_NAME;
import static ab.issue.db.DbConstants.COLUMN_NAME_BARCODE_ID;
import static ab.issue.db.DbConstants.COLUMN_NAME_DISPLAY_VALUE;
import static ab.issue.db.DbConstants.COLUMN_NAME_EMAIL_ADDRESS;
import static ab.issue.db.DbConstants.COLUMN_NAME_EMAIL_BARCODE_ID;
import static ab.issue.db.DbConstants.COLUMN_NAME_EMAIL_BODY;
import static ab.issue.db.DbConstants.COLUMN_NAME_EMAIL_SUBJECT;
import static ab.issue.db.DbConstants.COLUMN_NAME_NOTES;
import static ab.issue.db.DbConstants.EMAIL_TABLE_NAME;

@Dao
public abstract class EmailDao extends BarcodeFormatValueDao<EmailBarcodeFormat, EmailBarcode> {

    @Override
    @Query("SELECT " + EMAIL_TABLE_NAME + ".*, " + BARCODE_TABLE_NAME + ".* " +
            "FROM " + EMAIL_TABLE_NAME + " " +
            "INNER JOIN " + BARCODE_TABLE_NAME + " " +
            "ON " + COLUMN_NAME_EMAIL_BARCODE_ID + " = " + COLUMN_NAME_BARCODE_ID + " " +
            "WHERE " + COLUMN_NAME_EMAIL_ADDRESS + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_EMAIL_BODY + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_EMAIL_SUBJECT + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_NOTES + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_DISPLAY_VALUE + " LIKE '%' || :text || '%'")
    abstract List<EmailBarcode> findText(String text);
}
