package ab.issue.db;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import javax.inject.Inject;

import ab.issue.model.Barcode;

class ImageCheckerBarcodeDao extends UpdateTimeOnUpsertBarcodeDao {

    @Inject
    ImageCheckerBarcodeDao(BarcodeDatabase barcodeDatabase) {
        super(barcodeDatabase);
    }

    @Override
    public List<Barcode> insertBarcodes(List<Barcode> barcodes) {
        clearMissingImagePath(barcodes);
        return super.insertBarcodes(barcodes);
    }

    @Override
    public int update(Barcode barcode, boolean favorite) {
        clearMissingImagePath(barcode);
        return super.update(barcode, favorite);
    }

    @Override
    public int update(Barcode barcode) {
        clearMissingImagePath(barcode);
        return super.update(barcode);
    }

    @Override
    public int update(Collection<Barcode> barcodes) {
        clearMissingImagePath(barcodes);
        return super.update(barcodes);
    }

    @Override
    public void delete(Barcode barcode) {
        super.delete(barcode);
        deleteImage(barcode);
    }

    @Override
    public void delete(Barcode[] rows) {
        super.delete(rows);
        deleteImages(Arrays.asList(rows));
    }

    @Override
    public void delete(Collection<Barcode> rows) {
        super.delete(rows);
        deleteImages(rows);
    }

    private void clearMissingImagePath(Collection<Barcode> barcodes) {
        for (Barcode barcode : barcodes) {
            clearMissingImagePath(barcode);
        }
    }

    private void clearMissingImagePath(Barcode barcode) {
//        if (!FileUtils.exists(barcode.getImagePath())) {
//            barcode.setImagePath(null);
//        }
    }

    private void deleteImages(Collection<Barcode> barcodes) {
        for (Barcode barcode : barcodes) {
            deleteImage(barcode);
        }
    }

    private void deleteImage(Barcode barcode) {
//        FileUtils.delete(barcode.getImagePath());
    }
}
