package ab.issue.db;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Query;

import java.util.List;

import ab.issue.db.model.PhoneBarcode;
import ab.issue.model.values.PhoneBarcodeFormat;

import static ab.issue.db.DbConstants.BARCODE_TABLE_NAME;
import static ab.issue.db.DbConstants.COLUMN_NAME_BARCODE_ID;
import static ab.issue.db.DbConstants.COLUMN_NAME_DISPLAY_VALUE;
import static ab.issue.db.DbConstants.COLUMN_NAME_NOTES;
import static ab.issue.db.DbConstants.COLUMN_NAME_PHONE_BARCODE_ID;
import static ab.issue.db.DbConstants.COLUMN_NAME_PHONE_NUMBER;
import static ab.issue.db.DbConstants.PHONE_TABLE_NAME;

@Dao
@SuppressWarnings("WeakerAccess")
public abstract class PhoneDao extends BarcodeFormatValueDao<PhoneBarcodeFormat, PhoneBarcode> {

    @Override
    @Query("SELECT " + PHONE_TABLE_NAME + ".*, " + BARCODE_TABLE_NAME + ".* " +
            "FROM " + PHONE_TABLE_NAME + " " +
            "INNER JOIN " + BARCODE_TABLE_NAME + " " +
            "ON " + COLUMN_NAME_PHONE_BARCODE_ID + " = " + COLUMN_NAME_BARCODE_ID + " " +
            "WHERE " + COLUMN_NAME_PHONE_NUMBER + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_NOTES + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_DISPLAY_VALUE + " LIKE '%' || :text || '%'")
    abstract List<PhoneBarcode> findText(String text);
}

