package ab.issue.db;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Query;
import android.arch.persistence.room.Transaction;

import com.google.common.collect.FluentIterable;

import java.util.ArrayList;
import java.util.List;

import ab.issue.db.model.BarcodeSearchEntity;
import ab.issue.model.Barcode;

import static ab.issue.db.DbConstants.BARCODE_TABLE_NAME;
import static ab.issue.db.DbConstants.COLUMN_NAME_DISPLAY_VALUE;
import static ab.issue.db.DbConstants.COLUMN_NAME_FORMAT;
import static ab.issue.db.DbConstants.COLUMN_NAME_NOTES;

@SuppressWarnings("Guava")
@Dao
public abstract class SearchDao {

    @Transaction
    @Query("SELECT * FROM " + BARCODE_TABLE_NAME + " " +
            "WHERE " + COLUMN_NAME_FORMAT + " IN (:formats) " +
            "AND (" + COLUMN_NAME_NOTES + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_DISPLAY_VALUE + " LIKE '%' || :text || '%')")
    abstract List<BarcodeSearchEntity> findTextByFormat(String text, List<Integer> formats);

    public List<Barcode> findTextInBarcodesByFormat(String query, List<Integer> formats) {
//        List<Barcode> result = CollectionUtils.isEmpty(formats) ? new ArrayList<>() : toBarcodes(findTextByFormat(query, formats));
//        Timber.d("query=%s formats=%s result=%s", query, formats, result);
//        return result;
        return new ArrayList<>();
    }

    private List<Barcode> toBarcodes(Iterable<BarcodeSearchEntity> barcodeEntries) {
        return FluentIterable.from(barcodeEntries)
                .transform(BarcodeSearchEntity::fillValue)
                .toList();
    }
}
