package ab.issue.db;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Query;

import java.util.List;

import ab.issue.db.model.SmsBarcode;
import ab.issue.model.values.SmsBarcodeFormat;

import static ab.issue.db.DbConstants.BARCODE_TABLE_NAME;
import static ab.issue.db.DbConstants.COLUMN_NAME_BARCODE_ID;
import static ab.issue.db.DbConstants.COLUMN_NAME_DISPLAY_VALUE;
import static ab.issue.db.DbConstants.COLUMN_NAME_NOTES;
import static ab.issue.db.DbConstants.COLUMN_NAME_SMS_BARCODE_ID;
import static ab.issue.db.DbConstants.COLUMN_NAME_SMS_BODY;
import static ab.issue.db.DbConstants.COLUMN_NAME_SMS_NUMBER;
import static ab.issue.db.DbConstants.SMS_TABLE_NAME;

@Dao
public abstract class SmsDao extends BarcodeFormatValueDao<SmsBarcodeFormat, SmsBarcode> {

    @Override
    @Query("SELECT " + SMS_TABLE_NAME + ".*, " + BARCODE_TABLE_NAME + ".* " +
            "FROM " + SMS_TABLE_NAME + " " +
            "INNER JOIN " + BARCODE_TABLE_NAME + " " +
            "ON " + COLUMN_NAME_SMS_BARCODE_ID + " = " + COLUMN_NAME_BARCODE_ID + " " +
            "WHERE " + COLUMN_NAME_SMS_BODY + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_SMS_NUMBER + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_NOTES + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_DISPLAY_VALUE + " LIKE '%' || :text || '%'")
    abstract List<SmsBarcode> findText(String text);
}
