package ab.issue.db;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Query;

import java.util.List;

import ab.issue.db.model.UrlBarcode;
import ab.issue.model.values.UrlBarcodeFormat;

import static ab.issue.db.DbConstants.BARCODE_TABLE_NAME;
import static ab.issue.db.DbConstants.COLUMN_NAME_BARCODE_ID;
import static ab.issue.db.DbConstants.COLUMN_NAME_DISPLAY_VALUE;
import static ab.issue.db.DbConstants.COLUMN_NAME_NOTES;
import static ab.issue.db.DbConstants.COLUMN_NAME_URL;
import static ab.issue.db.DbConstants.COLUMN_NAME_URL_BARCODE_ID;
import static ab.issue.db.DbConstants.COLUMN_NAME_URL_TITLE;
import static ab.issue.db.DbConstants.URL_TABLE_NAME;

@Dao
public abstract class UrlDao extends BarcodeFormatValueDao<UrlBarcodeFormat, UrlBarcode> {

    @Override
    @Query("SELECT " + URL_TABLE_NAME + ".*, " + BARCODE_TABLE_NAME + ".* " +
            "FROM " + URL_TABLE_NAME + " " +
            "INNER JOIN " + BARCODE_TABLE_NAME + " " +
            "ON " + COLUMN_NAME_URL_BARCODE_ID + " = " + COLUMN_NAME_BARCODE_ID + " " +
            "WHERE " + COLUMN_NAME_URL_TITLE + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_URL + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_NOTES + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_DISPLAY_VALUE + " LIKE '%' || :text || '%'")
    abstract List<UrlBarcode> findText(String text);
}
