package ab.issue.db;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Query;

import java.util.List;

import ab.issue.db.model.WifiBarcode;
import ab.issue.model.values.WifiBarcodeFormat;

import static ab.issue.db.DbConstants.BARCODE_TABLE_NAME;
import static ab.issue.db.DbConstants.COLUMN_NAME_BARCODE_ID;
import static ab.issue.db.DbConstants.COLUMN_NAME_DISPLAY_VALUE;
import static ab.issue.db.DbConstants.COLUMN_NAME_NOTES;
import static ab.issue.db.DbConstants.COLUMN_NAME_WIFI_BARCODE_ID;
import static ab.issue.db.DbConstants.COLUMN_NAME_WIFI_PASSWORD;
import static ab.issue.db.DbConstants.COLUMN_NAME_WIFI_SSID;
import static ab.issue.db.DbConstants.WIFI_TABLE_NAME;

@Dao
public abstract class WifiDao extends BarcodeFormatValueDao<WifiBarcodeFormat, WifiBarcode> {

    @Override
    @Query("SELECT " + BARCODE_TABLE_NAME + ".*, " + WIFI_TABLE_NAME + ".*" + " " +
            "FROM " + WIFI_TABLE_NAME + " " +
            "INNER JOIN " + BARCODE_TABLE_NAME + " " +
            "ON " + COLUMN_NAME_WIFI_BARCODE_ID + " = " + COLUMN_NAME_BARCODE_ID + " " +
            "WHERE " + COLUMN_NAME_WIFI_SSID + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_WIFI_PASSWORD + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_NOTES + " LIKE '%' || :text || '%' " +
            "OR " + COLUMN_NAME_DISPLAY_VALUE + " LIKE '%' || :text || '%'")
    abstract List<WifiBarcode> findText(String text);

}
