package ab.issue.db.model;

import com.google.common.collect.FluentIterable;

import java.util.List;

import ab.issue.model.Barcode;
import ab.issue.model.values.BarcodeFormatValue;

@SuppressWarnings("Guava")
public abstract class BarcodeFormatValueWrapper<T extends BarcodeFormatValue> {

    protected abstract Barcode getBarcode();

    protected abstract T getFormatValue();

    public Barcode getBarcodeWithFormatValue() {
        getBarcode().getFormat().setValue(getFormatValue());
        return getBarcode();
    }

    public static List<Barcode> toBarcodes(List<? extends BarcodeFormatValueWrapper> wrappers) {
        return FluentIterable.from(wrappers)
                .transform(BarcodeFormatValueWrapper::getBarcodeWithFormatValue)
                .toList();
    }
}
