package ab.issue.db.model;

import android.arch.persistence.room.Embedded;
import android.arch.persistence.room.Relation;

import com.google.common.base.MoreObjects;

import java.util.List;

import javax.annotation.Nonnull;

import ab.issue.db.DbConstants;
import ab.issue.model.Barcode;
import ab.issue.model.values.CalendarEventBarcodeFormat;
import ab.issue.model.values.ContactInfoBarcodeFormat;
import ab.issue.model.values.EmailBarcodeFormat;
import ab.issue.model.values.GeoBarcodeFormat;
import ab.issue.model.values.PhoneBarcodeFormat;
import ab.issue.model.values.SmsBarcodeFormat;
import ab.issue.model.values.UrlBarcodeFormat;
import ab.issue.model.values.WifiBarcodeFormat;

public class BarcodeHistoryEntity {

    @Embedded
    public Barcode barcode;

    @Relation(parentColumn = DbConstants.COLUMN_NAME_BARCODE_ID, entityColumn = DbConstants.COLUMN_NAME_EVENT_BARCODE_ID)
    public List<CalendarEventBarcodeFormat> calendarEvents;

    @Relation(parentColumn = DbConstants.COLUMN_NAME_BARCODE_ID, entityColumn = DbConstants.COLUMN_NAME_CONTACT_BARCODE_ID)
    public List<ContactInfoBarcodeFormat> contacts;

    @Relation(parentColumn = DbConstants.COLUMN_NAME_BARCODE_ID, entityColumn = DbConstants.COLUMN_NAME_EMAIL_BARCODE_ID)
    public List<EmailBarcodeFormat> emails;

    @Relation(parentColumn = DbConstants.COLUMN_NAME_BARCODE_ID, entityColumn = DbConstants.COLUMN_NAME_GEO_BARCODE_ID)
    public List<GeoBarcodeFormat> geo;

    @Relation(parentColumn = DbConstants.COLUMN_NAME_BARCODE_ID, entityColumn = DbConstants.COLUMN_NAME_PHONE_BARCODE_ID)
    public List<PhoneBarcodeFormat> phones;

    @Relation(parentColumn = DbConstants.COLUMN_NAME_BARCODE_ID, entityColumn = DbConstants.COLUMN_NAME_SMS_BARCODE_ID)
    public List<SmsBarcodeFormat> sms;

    @Relation(parentColumn = DbConstants.COLUMN_NAME_BARCODE_ID, entityColumn = DbConstants.COLUMN_NAME_URL_BARCODE_ID)
    public List<UrlBarcodeFormat> urls;

    @Relation(parentColumn = DbConstants.COLUMN_NAME_BARCODE_ID, entityColumn = DbConstants.COLUMN_NAME_WIFI_BARCODE_ID)
    public List<WifiBarcodeFormat> wifi;

    public Barcode fillValue() {
        barcode.getFormat().setValue(calendarEvents, contacts, emails, geo, phones, sms, urls, wifi);
        return barcode;
    }

    @Nonnull
    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("barcode", barcode)
                .add("wifi", wifi)
                .omitNullValues()
                .toString();
    }
}
