package ab.issue.db.model;

import android.arch.persistence.room.Embedded;

import ab.issue.model.Barcode;
import ab.issue.model.values.EmailBarcodeFormat;

public class EmailBarcode extends BarcodeFormatValueWrapper<EmailBarcodeFormat> {

    @Embedded
    public Barcode barcode;

    @Embedded
    public EmailBarcodeFormat emailBarcodeFormat;

    @Override
    protected Barcode getBarcode() {
        return barcode;
    }

    @Override
    protected EmailBarcodeFormat getFormatValue() {
        return emailBarcodeFormat;
    }
}
