package ab.issue.di;

import android.app.Application;

import javax.inject.Singleton;

import ab.issue.db.DatabaseModule;
import app.issue.commons.CommonsModule;
import dagger.BindsInstance;
import dagger.Component;
import dagger.android.AndroidInjectionModule;
import dagger.android.AndroidInjector;
import dagger.android.support.AndroidSupportInjectionModule;
import dagger.android.support.DaggerApplication;

/**
 * Created by ankit on 28/3/17.
 */
@Singleton
@Component(modules = {
        AndroidInjectionModule.class,
        AndroidSupportInjectionModule.class,
        CommonsModule.class,
        DatabaseModule.class,
        HomeActivityModule.class,
        ViewModelBindingModule.class
})
public interface AppComponent extends AndroidInjector<DaggerApplication> {

    @Component.Builder
    interface Builder {

        @BindsInstance
        Builder application(Application application);

        Builder commonModule(CommonsModule commonsModule);

        AppComponent build();
    }
}
