package ab.issue.model.formats;

import app.issue.commons.java.ValueEnum;

public enum BarcodeFormatType implements ValueEnum {

    UNKNOWN(0, BarcodeDimension.UNKNOWN),
    AZTEC(1, BarcodeDimension.TWO_D),
    CODABAR(2, BarcodeDimension.ONE_D),
    CODE_128(3, BarcodeDimension.ONE_D),
    CODE_39(4, BarcodeDimension.ONE_D),
    CODE_93(5, BarcodeDimension.ONE_D),
    DATA_MATRIX(6, BarcodeDimension.TWO_D),
    EAN_13(7, BarcodeDimension.ONE_D),
    EAN_8(8, BarcodeDimension.ONE_D),
    ITF(9, BarcodeDimension.ONE_D),
    PDF_417(10, BarcodeDimension.TWO_D),
    QR_CODE(11, BarcodeDimension.TWO_D),
    UPC_A(12, BarcodeDimension.ONE_D),
    UPC_E(13, BarcodeDimension.ONE_D);

    private final int value;
    private final BarcodeDimension dimension;

    BarcodeFormatType(int value, BarcodeDimension dimension) {
        this.value = value;
        this.dimension = dimension;
    }

    @Override
    public int getValue() {
        return value;
    }

    public BarcodeDimension getDimension() {
        return dimension;
    }
}
