package ab.issue.model.formats;

import android.content.Context;

import com.google.zxing.BarcodeFormat;

import ab.issue.model.values.TextBarcodeFormat;

public class CodabarBarcodeFormat extends BaseBarcodeFormat {

    public static final String NAME = "Codabar";

    private static final String ALLOWED_CHARS_REGEX = "[^0-9-$:/.+]";
    private static final String ALLOWED_CHARS = "0-9 - $ : / . +";

    CodabarBarcodeFormat(TextBarcodeFormat valueType) {
        super(valueType);
    }

    @Override
    public String getName(Context context) {
        return NAME;
    }

    @Override
    public BarcodeFormatType getType() {
        return BarcodeFormatType.CODABAR;
    }

    @Override
    public BarcodeFormat getZxingBarcodeFormat() {
        return BarcodeFormat.CODABAR;
    }

}
