package ab.issue.model.formats;

import android.content.Context;

import com.google.zxing.BarcodeFormat;

import ab.issue.model.values.TextBarcodeFormat;

public class Code93BarcodeFormat extends BaseBarcodeFormat {

    public static final String NAME = "Code 93";

    Code93BarcodeFormat(TextBarcodeFormat valueType) {
        super(valueType);
    }

    @Override
    public String getName(Context context) {
        return NAME;
    }

    @Override
    public BarcodeFormatType getType() {
        return BarcodeFormatType.CODE_93;
    }

    @Override
    public BarcodeFormat getZxingBarcodeFormat() {
        return BarcodeFormat.CODE_93;
    }
}
