package ab.issue.model.formats;

import android.content.Context;
import android.support.annotation.NonNull;

import com.google.common.base.MoreObjects;
import com.google.zxing.BarcodeFormat;

import ab.issue.model.values.TextBarcodeFormat;

public class EAN13BarcodeFormat extends BaseBarcodeFormat {

    public static final String NAME = "EAN-13";
    private static final int LENGTH = 12;

    EAN13BarcodeFormat(TextBarcodeFormat valueType) {
        super(valueType);
    }

    @Override
    public BarcodeFormatType getType() {
        return BarcodeFormatType.EAN_13;
    }

    @Override
    public String getName(Context context) {
        return NAME;
    }


    @Override
    public BarcodeFormat getZxingBarcodeFormat() {
        return BarcodeFormat.EAN_13;
    }


    @NonNull
    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("type", getType())
                .add("valueType", getValue())
                .toString();
    }
}
