package ab.issue.model.formats;

import android.content.Context;

import com.google.zxing.BarcodeFormat;

import ab.issue.model.values.TextBarcodeFormat;

public class EAN8BarcodeFormat extends BaseBarcodeFormat {

    public static final String NAME = "EAN-8";

    private static final int LENGTH = 7;

    EAN8BarcodeFormat(TextBarcodeFormat valueType) {
        super(valueType);
    }

    @Override
    public String getName(Context context) {
        return NAME;
    }

    @Override
    public BarcodeFormatType getType() {
        return BarcodeFormatType.EAN_8;
    }


    @Override
    public BarcodeFormat getZxingBarcodeFormat() {
        return BarcodeFormat.EAN_8;
    }

}
