package ab.issue.model.formats;

import android.content.Context;

import com.google.zxing.BarcodeFormat;

import ab.issue.model.values.TextBarcodeFormat;

public class ITFBarcodeFormat extends BaseBarcodeFormat {

    public static final String NAME = "ITF";

    private static final int LENGTH = 40;

    ITFBarcodeFormat(TextBarcodeFormat valueType) {
        super(valueType);
    }

    @Override
    public String getName(Context context) {
        return NAME;
    }

    @Override
    public BarcodeFormatType getType() {
        return BarcodeFormatType.ITF;
    }

    @Override
    public BarcodeFormat getZxingBarcodeFormat() {
        return BarcodeFormat.ITF;
    }

}
