package ab.issue.model.formats;

import android.content.Context;

import com.google.zxing.BarcodeFormat;

import ab.issue.model.values.TextBarcodeFormat;

public class PDF417BarcodeFormat extends BaseBarcodeFormat {

    public static final String NAME = "PDF-417";

    PDF417BarcodeFormat(TextBarcodeFormat valueType) {
        super(valueType);
    }

    @Override
    public String getName(Context context) {
        return NAME;
    }

    @Override
    public BarcodeFormatType getType() {
        return BarcodeFormatType.PDF_417;
    }

    @Override
    public BarcodeFormat getZxingBarcodeFormat() {
        return BarcodeFormat.PDF_417;
    }

}
