package ab.issue.model.formats;

import android.content.Context;

import ab.issue.model.values.BarcodeFormatValue;
import ab.issue.model.values.CalendarEventBarcodeFormat;
import ab.issue.model.values.ContactInfoBarcodeFormat;
import ab.issue.model.values.Email;
import ab.issue.model.values.EmailBarcodeFormat;
import ab.issue.model.values.GeoBarcodeFormat;
import ab.issue.model.values.Phone;
import ab.issue.model.values.PhoneBarcodeFormat;
import ab.issue.model.values.SmsBarcodeFormat;
import ab.issue.model.values.UrlBarcodeFormat;
import ab.issue.model.values.UrlBookmark;
import ab.issue.model.values.WifiBarcodeFormat;

public class QRCodeBarcodeFormat extends BaseBarcodeFormat {

    public static QRCodeBarcodeFormat newCalendarEvent() {
        return new QRCodeBarcodeFormat(new CalendarEventBarcodeFormat());
    }

    public static QRCodeBarcodeFormat newContactInfo() {
        return new QRCodeBarcodeFormat(new ContactInfoBarcodeFormat());
    }

    public static QRCodeBarcodeFormat newEmail() {
        return new QRCodeBarcodeFormat(new EmailBarcodeFormat(new Email()));
    }

    public static QRCodeBarcodeFormat newGeo() {
        return new QRCodeBarcodeFormat(new GeoBarcodeFormat());
    }

    public static QRCodeBarcodeFormat newSms() {
        return new QRCodeBarcodeFormat(new SmsBarcodeFormat());
    }

    public static QRCodeBarcodeFormat newUrl() {
        return new QRCodeBarcodeFormat(new UrlBarcodeFormat(new UrlBookmark()));
    }

    QRCodeBarcodeFormat(BarcodeFormatValue valueType) {
        super(valueType);
    }

    public static QRCodeBarcodeFormat newWifi() {
        return new QRCodeBarcodeFormat(new WifiBarcodeFormat());
    }

    public static QRCodeBarcodeFormat newPhone() {
        return new QRCodeBarcodeFormat(new PhoneBarcodeFormat(new Phone()));
    }

    @Override
    public String getName(Context context) {
        return getValue().getName(context);
    }

    @Override
    public BarcodeFormatType getType() {
        return BarcodeFormatType.QR_CODE;
    }

    @Override
    public com.google.zxing.BarcodeFormat getZxingBarcodeFormat() {
        return com.google.zxing.BarcodeFormat.QR_CODE;
    }
}
