package ab.issue.model.formats;

import android.content.Context;

import com.google.zxing.BarcodeFormat;

import ab.issue.model.values.TextBarcodeFormat;

public class UPCABarcodeFormat extends BaseBarcodeFormat {

    public static final String NAME = "UPC-A";

    private static final int LENGTH = 11;

    UPCABarcodeFormat(TextBarcodeFormat valueType) {
        super(valueType);
    }

    @Override
    public String getName(Context context) {
        return NAME;
    }

    @Override
    public BarcodeFormatType getType() {
        return BarcodeFormatType.UPC_A;
    }

    @Override
    public BarcodeFormat getZxingBarcodeFormat() {
        return BarcodeFormat.UPC_A;
    }

}
