package ab.issue.model.formats;

import android.content.Context;

import com.google.zxing.BarcodeFormat;

import ab.issue.model.values.TextBarcodeFormat;

public class UPCEBarcodeFormat extends BaseBarcodeFormat {

    public static final String NAME = "UPC-E";
    private static final int LENGTH = 6;

    UPCEBarcodeFormat(TextBarcodeFormat valueType) {
        super(valueType);
    }

    @Override
    public String getName(Context context) {
        return NAME;
    }

    @Override
    public BarcodeFormatType getType() {
        return BarcodeFormatType.UPC_E;
    }


    @Override
    public BarcodeFormat getZxingBarcodeFormat() {
        return BarcodeFormat.UPC_E;
    }

}
