package ab.issue.model.formats;

import android.content.Context;

import java.util.List;

import ab.issue.model.values.BarcodeFormatValue;
import ab.issue.model.values.CalendarEventBarcodeFormat;
import ab.issue.model.values.ContactInfoBarcodeFormat;
import ab.issue.model.values.EmailBarcodeFormat;
import ab.issue.model.values.GeoBarcodeFormat;
import ab.issue.model.values.PhoneBarcodeFormat;
import ab.issue.model.values.SmsBarcodeFormat;
import ab.issue.model.values.UnknownBarcodeFormatValue;
import ab.issue.model.values.UrlBarcodeFormat;
import ab.issue.model.values.WifiBarcodeFormat;

public class UnknownBarcodeFormat implements BarcodeFormat {

    @Override
    public BarcodeFormatType getType() {
        return BarcodeFormatType.UNKNOWN;
    }

    @Override
    public String getName(Context context) {
        return context.getString(android.R.string.unknownName);
    }

    @Override
    public BarcodeFormatValue getValue() {
        return UnknownBarcodeFormatValue.INSTANCE;
    }

    @Override
    public void setValue(List<CalendarEventBarcodeFormat> calendarEvents,
                         List<ContactInfoBarcodeFormat> contacts,
                         List<EmailBarcodeFormat> emails,
                         List<GeoBarcodeFormat> geo,
                         List<PhoneBarcodeFormat> phones,
                         List<SmsBarcodeFormat> sms,
                         List<UrlBarcodeFormat> urls,
                         List<WifiBarcodeFormat> wifi) {
    }

    @Override
    public com.google.zxing.BarcodeFormat getZxingBarcodeFormat() {
        throw new IllegalStateException();
    }

    @Override
    public void setValue(BarcodeFormatValue formatValue) {
    }
}
