package ab.issue.model.values;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.TypeConverter;
import android.arch.persistence.room.TypeConverters;
import android.support.annotation.Nullable;

import com.google.common.base.MoreObjects;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.zxing.client.result.EmailAddressParsedResult;

import java.util.List;

import javax.annotation.Nonnull;

import ab.issue.db.DbConstants;

@SuppressWarnings("Guava")
public class Email {

    @TypeConverter
    public static String fromEmails(List<Email> emails) {
        return new Gson().toJson(emails);
    }

    @TypeConverter
    public static List<Email> fromEmailsJson(String emails) {
        TypeToken<List<Email>> typeToken = new TypeToken<List<Email>>() {
        };
        return new Gson().fromJson(emails, typeToken.getType());
    }

    public static Email create(@Nullable FirebaseVisionBarcode.Email email) {
        Email result = new Email();
        if (email != null) {
            result.subject = email.getSubject();
            result.address = email.getAddress();
            result.body = email.getBody();
            result.location = Location.fromFirebaseEmailType(email.getType());
        }
        return result;
    }

    public static Email create(EmailAddressParsedResult emailResult) {
        Email email = new Email();
        if (emailResult != null) {
//            email.address = ArrayUtils.getFirstItem(emailResult.getTos());
            email.body = emailResult.getBody();
            email.subject = emailResult.getSubject();
        }
        return email;
    }

    public static Email create(String address) {
        Email email = new Email();
        email.address = address;
        return email;
    }

    @ColumnInfo(name = DbConstants.COLUMN_NAME_EMAIL_ADDRESS)
    private String address;

    @ColumnInfo(name = DbConstants.COLUMN_NAME_EMAIL_SUBJECT)
    private String subject;

    @ColumnInfo(name = DbConstants.COLUMN_NAME_EMAIL_BODY)
    private String body;

    @TypeConverters(Location.class)
    @ColumnInfo(name = DbConstants.COLUMN_NAME_EMAIL_LOCATION)
    private Location location;

    @Nonnull
    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("address", address)
                .add("subject", subject)
                .add("body", body)
                .add("location", location)
                .omitNullValues()
                .toString();
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Location getLocation() {
        return location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public String getSubject() {
        return subject;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }
}
