package ab.issue.model.values;

import android.arch.persistence.room.TypeConverter;
import android.content.Context;
import android.support.annotation.Nullable;

import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;

import app.issue.commons.java.ValueEnum;

public enum Location implements ValueEnum {
    WORK(0),
    HOME(1);

    private final int value;

    Location(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return value;
    }

    String getName(Context context) {
        throw new IllegalStateException("Invalid object=" + this);
    }

    static Location fromFirebaseEmailType(int emailType) {
        switch (emailType) {
            case FirebaseVisionBarcode.Email.TYPE_HOME:
                return HOME;
            case FirebaseVisionBarcode.Email.TYPE_WORK:
                return WORK;
            case FirebaseVisionBarcode.Email.TYPE_UNKNOWN:
            default:
                return null;
        }
    }

    static Location fromFirebaseAddressType(int addressType) {
        switch (addressType) {
            case FirebaseVisionBarcode.Address.TYPE_HOME:
                return HOME;
            case FirebaseVisionBarcode.Address.TYPE_WORK:
                return WORK;
            case FirebaseVisionBarcode.Address.TYPE_UNKNOWN:
            default:
                return null;
        }
    }

    @TypeConverter
    public static Location fromValue(int locationValue) {
        return locationValue == -1 ? null : ValueEnum.fromValue(Location.values(), locationValue);
    }

    @TypeConverter
    public static int toValue(@Nullable Location location) {
        return location == null ? -1 : location.getValue();
    }
}
